// ImageDeinterlacerDlg.cpp : implementation file
//

#include "stdafx.h"
#include "ImageDeinterlacer.h"
#include "ImageDeinterlacerDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CImageDeinterlacerDlg dialog

CImageDeinterlacerDlg::CImageDeinterlacerDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CImageDeinterlacerDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CImageDeinterlacerDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);

	m_pStream = NULL;

	m_pYUVFrameBuffer = NULL;

	m_pYUVFrameBufferTemp = NULL;

	m_pRGBFrameBuffer = NULL;

	m_hDeinterlaceVideoDev = 0xFFFFFFFF;

	m_bStop = FALSE;

	hConvertThread = NULL;

	m_nDstStreamBufferSize = 0;
}

void CImageDeinterlacerDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CImageDeinterlacerDlg)
	DDX_Control(pDX, IDC_DEST_IMG_PREVIEW, m_scDestImgPreview);
	DDX_Control(pDX, IDC_LIST_DESTINATION_IMAGE, m_listDestImage);
	DDX_Control(pDX, IDC_EDIT_MESSAGE, m_editMessage);
	DDX_Text(pDX, IDC_EDIT_DSTFOLDERPATH, m_strDstFolderPath);
	DDX_Control(pDX, IDC_IMG_PREVIEW, m_scImgPrevew);
	DDX_Control(pDX, IDC_BTN_STOP, m_btnStop);
	DDX_Control(pDX, IDC_BTN_CONVERT, m_btnConvert);
	DDX_Control(pDX, IDC_RADIO_BLENDING_METHOD, m_btnBlending);
	DDX_Control(pDX, IDC_RADIO_MOTION_ADAPTER_METHOD, m_btnMotionAdapter);
	DDX_Control(pDX, IDC_RADIO_TRIANGLE_FILTERING, m_btnTriangleFiltering);
	DDX_Control(pDX, IDC_LIST_SOURCE_IMAGE, m_listSrcImage);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CImageDeinterlacerDlg, CDialog)
	//{{AFX_MSG_MAP(CImageDeinterlacerDlg)
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_WM_DESTROY()
	ON_BN_CLICKED(IDC_BTN_ADD, OnBtnAdd)
	ON_BN_CLICKED(IDC_BTN_REMOVE, OnBtnRemove)
	ON_BN_CLICKED(IDC_BTN_REMOVE_ALL, OnBtnRemoveAll)
	ON_LBN_SELCHANGE(IDC_LIST_SOURCE_IMAGE, OnSelchangeListSourceImage)
	ON_BN_CLICKED(IDC_BTN_DSTFOLDER, OnBtnDstfolder)
	ON_BN_CLICKED(IDC_BTN_CONVERT, OnBtnConvert)
	ON_BN_CLICKED(IDC_BTN_STOP, OnBtnStop)
	ON_LBN_SELCHANGE(IDC_LIST_DESTINATION_IMAGE, OnSelchangeListDestinationImage)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CImageDeinterlacerDlg message handlers

BOOL CImageDeinterlacerDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	// TODO: Add extra initialization here
	
	m_btnBlending.SetCheck( BST_CHECKED );

	m_btnMotionAdapter.SetCheck( BST_UNCHECKED );

	m_btnTriangleFiltering.SetCheck( BST_UNCHECKED );

	m_listSrcImage.EnableScrollBarCtrl(TRUE);

	m_listSrcImage.SendMessage(LB_SETHORIZONTALEXTENT, 800, 0); 

	m_editMessage.SetBackColor(RGB(255, 255, 255));

	m_editMessage.SetTextColor(RGB(0, 0, 255));

	m_editMessage.SetWindowText("(Convert Tool) : Ready ! \r\n");

	m_pYUVFrameBuffer = (BYTE *)(malloc( 1920 * 1080 * 2 ));

	ZeroMemory( m_pYUVFrameBuffer, 1920 * 1080 * 2 );

	m_pYUVFrameBufferTemp = m_pYUVFrameBuffer;

	m_pRGBFrameBuffer = (BYTE *)(malloc( 1920 * 1080 * 4 ));

	ZeroMemory( m_pRGBFrameBuffer, 1920 * 1080 * 4 );

	m_hDeinterlaceVideoDev = AMESDK_CREATE( "Common Analog Deinterlacer", 0, 16, NULL, NULL, NULL );

	if( m_hDeinterlaceVideoDev & 0x80000000 ) 
	{ 
		m_hDeinterlaceVideoDev = 0xFFFFFFFF;
	}

	return TRUE;  // return TRUE  unless you set the focus to a control
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CImageDeinterlacerDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CImageDeinterlacerDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

void CImageDeinterlacerDlg::OnDestroy() 
{
	CDialog::OnDestroy();
	
	// TODO: Add your message handler code here
	
	if (hConvertThread != NULL) 
	{
		CloseHandle( hConvertThread );

		hConvertThread = NULL;
	}

	FreeData();
	
	if( m_hDeinterlaceVideoDev != 0xFFFFFFFF ) 
	{
		AMESDK_DESTROY( m_hDeinterlaceVideoDev ); 

		m_hDeinterlaceVideoDev = 0xFFFFFFFF;
	}

	free( m_pYUVFrameBufferTemp );

	free( m_pRGBFrameBuffer );
}

void CImageDeinterlacerDlg::OnBtnAdd() 
{
	// TODO: Add your control notification handler code here
	
	CString			csOpenFileName;

	TCHAR			szCpation[] = _T("Select image files to convert");

	TCHAR	strFileBuf[0x2000];

	::memset(strFileBuf, 0, sizeof(TCHAR) * 0x19F0);

	// Only allow .bmp, .png, .gif to retrieve their color palette
	//
	CFileDialog	fileDialog(	TRUE, 
										   _T("bmp"), 
										   NULL, 
										   NULL, 
										   _T("Image Files (*.bmp)|*.bmp|All Files (*.*)|*.*||") );

	fileDialog.m_ofn.lpstrTitle				= szCpation;

	fileDialog.m_ofn.lpstrInitialDir		= m_strBrowseSourceFilePath;

	fileDialog.m_ofn.nMaxFile				= 0x2000;

	fileDialog.m_ofn.lpstrFile				= strFileBuf;

	fileDialog.m_ofn.Flags |=	OFN_ALLOWMULTISELECT;

	CString	strImageFile;

	if (IDOK == fileDialog.DoModal())	
	{		
		POSITION pos = fileDialog.GetStartPosition();

		while (pos)
		{
			strImageFile = fileDialog.GetNextPathName(pos);
			m_listSrcImage.AddString(strImageFile);
		}

		CString strCurPath = fileDialog.GetPathName();

		if (strCurPath.Find('.') != -1)
			strCurPath = strCurPath.Left(strCurPath.ReverseFind('\\') + 1);

		m_strBrowseSourceFilePath = strCurPath; 
	}

	UpdateUI();
}

void CImageDeinterlacerDlg::UpdateUI()
{
	int nItemCount = m_listSrcImage.GetCount();

	CString strInputFilesNum;

	strInputFilesNum.Format("Input Files:  ( %d )", nItemCount);

	GetDlgItem(IDC_SC_INPUT_FILES)->SetWindowText( strInputFilesNum );

	GetDlgItem(IDC_EDIT_DSTFOLDERPATH)->SetWindowText( m_strDstFolderPath );

	if (nItemCount > 0)
		m_btnConvert.EnableWindow(TRUE);
	else
		m_btnConvert.EnableWindow(FALSE);

	m_scImgPrevew.Invalidate();

	Invalidate();
}

void CImageDeinterlacerDlg::OnBtnRemove() 
{
	// TODO: Add your control notification handler code here
	
	int nIndex = m_listSrcImage.GetCurSel();

	if (nIndex == LB_ERR)
		return;

	m_listSrcImage.DeleteString(nIndex);

	int nItemCount = m_listSrcImage.GetCount();

	if (nItemCount >= 1)
	{
		m_listSrcImage.SetCurSel(nIndex - 1);
	}

	if (nIndex == 0)
		m_listSrcImage.SetCurSel(0);

	OnSelchangeListSourceImage();

	if (nItemCount == 0)
	{
		m_scImgPrevew.FreeData();
		
		GetDlgItem(IDC_EDIT_DIMENSION)->SetWindowText("");
	}

	UpdateUI();
}

void CImageDeinterlacerDlg::OnBtnRemoveAll() 
{
	// TODO: Add your control notification handler code here
	
	m_listSrcImage.ResetContent();

	GetDlgItem(IDC_EDIT_DIMENSION)->SetWindowText("");
	
	m_scImgPrevew.FreeData();	

	UpdateUI();
}

void CImageDeinterlacerDlg::OnSelchangeListSourceImage() 
{
	// TODO: Add your control notification handler code here
	int nIndex = m_listSrcImage.GetCurSel();

	if (nIndex == LB_ERR)
		return;	

	CString	strImageFile;

	m_listSrcImage.GetText( nIndex, strImageFile);

	// Load an Image from File
	//
    m_scImgPrevew.Load( strImageFile );	

	UINT dwWidth = 0;

	UINT dwHeight = 0;

	ULONG nPixelFmt = 0;

	m_scImgPrevew.GetImageDimInfo(dwWidth, dwHeight, nPixelFmt);

	CString strImageSize;

	strImageSize.Format("%d x %d", dwWidth, dwHeight);

	GetDlgItem(IDC_EDIT_DIMENSION)->SetWindowText(strImageSize);	

	if ( nPixelFmt == PixelFormat32bppRGB ||  nPixelFmt == PixelFormat32bppARGB )
	{
		GetDlgItem(IDC_EDIT_BIT_DEPTH)->SetWindowText( "32 bits" );			
	}
	else if ( nPixelFmt == PixelFormat24bppRGB )
	{
		GetDlgItem(IDC_EDIT_BIT_DEPTH)->SetWindowText( "24 bits" );
	}
	else
	{
		GetDlgItem(IDC_EDIT_BIT_DEPTH)->SetWindowText( "Undefined pixel format" );	
	}

	m_scImgPrevew.Invalidate();

	Invalidate();
}

INT CALLBACK BrowseCallbackProc(	HWND				hWnd, 
																UINT				uMsg,
																LPARAM			lp, 
																LPARAM			lpData) 
{
   switch(uMsg) 
   {
	   case BFFM_INITIALIZED:       
		  ::SendMessage ( hWnd, BFFM_SETSELECTION, 1, lpData);
		  break;

		default:   
			break;   
   }
   return 0;
}

void CImageDeinterlacerDlg::OnBtnDstfolder() 
{
	// TODO: Add your control notification handler code here

	CString strLastPath = m_strOutputDirectory;

	LPMALLOC lpMalloc;  // pointer to IMalloc

	char szDisplayName[ _MAX_PATH ];

	char szBuffer[ _MAX_PATH ];

	BROWSEINFO bi;

	LPITEMIDLIST pidlRoot = NULL;

	LPITEMIDLIST lpItemIDList;

	if (::SHGetMalloc(&lpMalloc) != NOERROR)
		return; // failed to get allocator

	szBuffer[0] = '\0';

	bi.hwndOwner				= GetSafeHwnd();
    bi.pidlRoot					= pidlRoot; 
    bi.pszDisplayName		= szDisplayName; 
    bi.lpszTitle					= "Select a folder"; 
    bi.ulFlags						= BIF_RETURNONLYFSDIRS; 
    bi.lpfn							= BrowseCallbackProc;
    bi.lParam						= (LPARAM)(LPCTSTR)m_strOutputDirectory;
    bi.iImage						= 0;

	if ((lpItemIDList = ::SHBrowseForFolder(&bi)) != NULL) 
	{
		// Get the path of the selected folder from the item ID list.
		//
		::SHGetPathFromIDList(lpItemIDList, szBuffer);

		lpMalloc->Free(lpItemIDList);
	}

	lpMalloc->Release();      

	if (szBuffer[0] != '\0')
	{
		m_strDstFolderPath = szBuffer;			

		m_strOutputDirectory = m_strDstFolderPath;

		GetDlgItem(IDC_EDIT_DSTFOLDERPATH)->SetWindowText(m_strDstFolderPath);
	}
}

void CImageDeinterlacerDlg::OnBtnConvert() 
{
	// TODO: Add your control notification handler code here
	
	m_bStop = FALSE;

	m_btnStop.EnableWindow( TRUE );

	m_btnConvert.EnableWindow( FALSE );

	hConvertThread = CreateThread(NULL, 0, ConvertThreadFunc, this, 0, &dwConvertThreadId);
}

void CImageDeinterlacerDlg::OnBtnStop() 
{
	// TODO: Add your control notification handler code here
	
	m_bStop = TRUE;

	if (hConvertThread != NULL) 
	{
		CloseHandle(hConvertThread);

		hConvertThread = NULL;
	}

	m_btnStop.EnableWindow( FALSE );

	m_btnConvert.EnableWindow( TRUE );
}

BOOL CImageDeinterlacerDlg::LoadImageToStream(CString szFilePath)
{
	// Set success error state
	//
    SetLastError( ERROR_SUCCESS );

    FreeData(); 

    // Allocate stream
	//
    DWORD dwResult = CreateStreamOnHGlobal(NULL, TRUE, &m_pStream);

    if(dwResult != S_OK)
    {
        SetLastError( dwResult );

        return FALSE;
    } 

	// Open the specified file
	//
    CFile cFile;

    CFileException cFileException;

    if(!cFile.Open(szFilePath, CStdioFile::modeRead | CStdioFile::typeBinary, &cFileException))
    {
        SetLastError(cFileException.m_lOsError);

        SAFE_RELEASE(m_pStream);

        return FALSE;
    } 

    // Copy the specified file's content to the stream
	//
    BYTE pBuffer[ 1024 ] = {0};

	UINT dwRead = 0;

    while(dwRead = cFile.Read(pBuffer, 1024))
    {
        dwResult = m_pStream->Write(pBuffer, dwRead, NULL);

        if(dwResult != S_OK)
        {
            SetLastError( dwResult );

            SAFE_RELEASE(m_pStream);

            cFile.Close();

            return FALSE;
        }
    } 
	
    // Close the file
	//
    cFile.Close(); 

	return TRUE;
}

void CImageDeinterlacerDlg::FreeData()
{
    SAFE_RELEASE( m_pStream );
}

CString CImageDeinterlacerDlg::GetWorkingPath()
{
	TCHAR szCurPath[MAX_PATH] = {0};

	GetModuleFileName(NULL, szCurPath, MAX_PATH);

	CString strCurPath = szCurPath;

	strCurPath = strCurPath.Left(strCurPath.ReverseFind('\\') + 1);

	return strCurPath;
}


void CImageDeinterlacerDlg::OnDrawItem(int nIDCtl, LPDRAWITEMSTRUCT lpDrawItemStruct) 
{
	// TODO: Add your message handler code here and/or call default
	
	m_scImgPrevew.DrawItem( lpDrawItemStruct ); 

	m_scDestImgPreview.DrawItem( lpDrawItemStruct ); 

	CDialog::OnDrawItem(nIDCtl, lpDrawItemStruct);
}

BOOL CImageDeinterlacerDlg::ippiRGBToYUV422( BYTE * pSrcFrameBuffer, ULONG nSrcFrameWidth, ULONG nSrcFrameHeight,  ULONG nBitDepth, BYTE * pDstStreamBuffer, ULONG * pDstStreamBufferSize )
{
	IppiSize srcSize    = { nSrcFrameWidth, nSrcFrameHeight };

	IppiRect srcRoi     = { 0, 0, nSrcFrameWidth, nSrcFrameHeight };

	IppiSize dstRoiSize = { nSrcFrameWidth, nSrcFrameHeight };

	// RGB32 TO RGB24
	//
	if ( nBitDepth == 32 )
	{
		int nDstStep1;

		Ipp8u * pDstRGB24 = ippiMalloc_8u_C3( nSrcFrameWidth, nSrcFrameHeight, &nDstStep1 );

		ippiCopy_8u_AC4C3R( pSrcFrameBuffer, nSrcFrameWidth * 4, pDstRGB24, nSrcFrameWidth * 3, dstRoiSize );

		ippiBGRToYCbCr422_8u_C3C2R( pDstRGB24, nSrcFrameWidth * 3, pDstStreamBuffer, nSrcFrameWidth * 2, dstRoiSize );

		ippiFree( pDstRGB24 );
	}
	
	// RGB24
	//
	if ( nBitDepth == 24 )
	{
		ippiRGBToYCbCr422_8u_C3C2R( pSrcFrameBuffer, nSrcFrameWidth * 3, pDstStreamBuffer, nSrcFrameWidth * 2, dstRoiSize );
	}	

	return TRUE;
}

BOOL CImageDeinterlacerDlg::YUV422toRGB(ULONG nSrcFrameWidth, ULONG nSrcFrameHeight, ULONG nBitDepth, BYTE * pInputFrameBuffer, BYTE * pOutputFrameBuffer )
{
	BOOL bConvert = FALSE;

	m_video_bitmap_info_header.biSize						= sizeof(BITMAPINFOHEADER);

	m_video_bitmap_info_header.biWidth					= nSrcFrameWidth;

	m_video_bitmap_info_header.biHeight					= nSrcFrameHeight;

	m_video_bitmap_info_header.biPlanes					= 1;

	m_video_bitmap_info_header.biBitCount				= (WORD)nBitDepth;

	m_video_bitmap_info_header.biCompression			= BI_RGB;
	
	m_video_bitmap_info_header.biSizeImage				= (nSrcFrameWidth * nSrcFrameHeight * ( nBitDepth / 8 ) );	

	m_video_bitmap_info_header.biXPelsPerMeter		= 0;

	m_video_bitmap_info_header.biYPelsPerMeter		= 0;

	m_video_bitmap_info_header.biClrUsed				= 0;

	m_video_bitmap_info_header.biClrImportant			= 0;

	// CONVERT BUFFER BY AMESDK LIB
	//
	// bConvert = COLORSPACE_YUY2_TO_RGB24_MMX( nSrcFrameWidth, nSrcFrameHeight, 0, nSrcFrameWidth, nSrcFrameHeight, 0, pOutputFrameBuffer, pInputFrameBuffer);

	// CONVERT BUFFER BY INTEL IPPI LIB
	//
	IppiSize srcSize    = { nSrcFrameWidth, nSrcFrameHeight };

	IppiRect srcRoi     = { 0, 0, nSrcFrameWidth, nSrcFrameHeight };

	IppiSize dstRoiSize = { nSrcFrameWidth, nSrcFrameHeight };

	if ( nBitDepth == 24 )
		ippiYCbCr422ToRGB_8u_C2C3R( pInputFrameBuffer, nSrcFrameWidth * 2, pOutputFrameBuffer, nSrcFrameWidth * 3, dstRoiSize );

	if ( nBitDepth == 32 )	
		ippiYCbCr422ToBGR_8u_C2C4R( pInputFrameBuffer, nSrcFrameWidth * 2, pOutputFrameBuffer, nSrcFrameWidth * 4, dstRoiSize, 0 );

	return bConvert;
}

BOOL CImageDeinterlacerDlg::ImageDeinterlace(BYTE * pSrcFrameBuffer, ULONG nSrcFrameWidth, ULONG nSrcFrameHeight, ULONG nDstStreamBufferSize)
{
	BOOL bSet = FALSE;

	if ( m_hDeinterlaceVideoDev != 0xFFFFFFFF )
	{
		AMESDK_STOP(m_hDeinterlaceVideoDev);

		// NTSC
		//
		// AMESDK_SET_FORMAT(m_hDeinterlaceVideoDev, MAKEFOURCC('Y', 'U', 'Y', '2'), nSrcFrameWidth, nSrcFrameHeight, 16, 29.97);

		// PAL
		//
		AMESDK_SET_FORMAT(m_hDeinterlaceVideoDev, MAKEFOURCC('Y', 'U', 'Y', '2'), nSrcFrameWidth, nSrcFrameHeight, 16, 25.00);

		// RUN SOFTWARE DEINTERLACE
        //
        AMESDK_RUN(m_hDeinterlaceVideoDev);		

		// DEINTERLACE METHOD
		//
		// 0 : Blending, 1 : Motion Adapter, 2 : Triangle Filtering
		//
		if ( m_btnBlending.GetCheck() ==  BST_CHECKED )
			bSet = AMESDK_DI_DEINTERLACE_METHOD( m_hDeinterlaceVideoDev, 0 ); 

		if ( m_btnMotionAdapter.GetCheck() == BST_CHECKED )
			bSet = AMESDK_DI_DEINTERLACE_METHOD( m_hDeinterlaceVideoDev, 1 ); 

		if ( m_btnTriangleFiltering.GetCheck() == BST_CHECKED )
			bSet = AMESDK_DI_DEINTERLACE_METHOD( m_hDeinterlaceVideoDev, 2 ); 

		bSet = AMESDK_DI_DEINTERLACE( m_hDeinterlaceVideoDev, pSrcFrameBuffer, nDstStreamBufferSize );
	}

	return bSet;
}

BOOL CImageDeinterlacerDlg::WriteToFile(CString strOutputFile, ULONG nSrcFrameWidth, ULONG nSrcFrameHeight, ULONG nBitDepth)
{
	BITMAPFILEHEADER BFH; ZeroMemory( &BFH, sizeof(BITMAPFILEHEADER) );

	BITMAPINFOHEADER BIH; ZeroMemory( &BIH, sizeof(BITMAPINFOHEADER) );

	DWORD dw			= 0x00000000;

	BFH.bfType				= (USHORT)(0x4D42);

	BFH.bfSize				= sizeof(BITMAPFILEHEADER) + sizeof(BITMAPINFOHEADER) + (nSrcFrameWidth * nSrcFrameHeight * ( nBitDepth / 8 ) );

	BFH.bfOffBits			= sizeof(BITMAPFILEHEADER) + sizeof(BITMAPINFOHEADER);

	BIH.biSize				= sizeof(BITMAPINFOHEADER);

	BIH.biWidth			= (LONG)(nSrcFrameWidth);

	BIH.biHeight			= (LONG)(nSrcFrameHeight) * (-1);

	BIH.biBitCount		= (USHORT)(nBitDepth);

	BIH.biSizeImage		= (ULONG)(nSrcFrameWidth * nSrcFrameHeight * ( nBitDepth / 8 ));

	BIH.biCompression = (BI_RGB);

	BIH.biPlanes			 = (1);

	HANDLE handle = CreateFile( strOutputFile, GENERIC_WRITE, FILE_SHARE_WRITE, NULL, CREATE_ALWAYS, 0, NULL );

	if( handle != INVALID_HANDLE_VALUE ) 
	{
		WriteFile( handle, &BFH, sizeof(BITMAPFILEHEADER), &dw, NULL );

		WriteFile( handle, &BIH, sizeof(BITMAPINFOHEADER), &dw, NULL );   

		WriteFile( handle, m_pRGBFrameBuffer, BIH.biSizeImage, &dw, NULL );
	}

	if( handle ) { CloseHandle( handle ); }

	return TRUE;
}

DWORD WINAPI CImageDeinterlacerDlg::ConvertThreadFunc( LPVOID lpParam ) 
{
	CImageDeinterlacerDlg *lpThis = (CImageDeinterlacerDlg *) lpParam;	

	int nItemCount = lpThis->m_listSrcImage.GetCount();	

	bool bConverting = false;

	int nConvertFile = 0;

	CString	strSrcImageFile, strDstImageFile;	

	CString strMessage = "------- Image Convert Status ------- \r\n\r\n";	

	lpThis->m_scDestImgPreview.FreeData();

	lpThis->m_listDestImage.ResetContent();

	lpThis->GetDlgItem(IDC_LIST_DESTINATION_IMAGE)->SetWindowText( "Output Files:  ( 0 )" );

	lpThis->Invalidate();

	for (int i=0 ; i<nItemCount && !lpThis->m_bStop ; i++)
	{
		lpThis->m_listSrcImage.GetText(i, strSrcImageFile);

		if ( !lpThis->LoadImageToStream( strSrcImageFile ) )
			continue;

		bConverting = false;

		lpThis->m_nDstStreamBufferSize = 0;

		if ( lpThis->m_pStream != NULL )
		{
			Bitmap bitmap( lpThis->m_pStream );

			BitmapData bmp_data = {0};

			ULONG nBitDepth = 0;

			Rect rect(0, 0, bitmap.GetWidth(), bitmap.GetHeight());

			CString strImageName = strSrcImageFile.Right( strSrcImageFile.GetLength() - strSrcImageFile.ReverseFind('\\') - 1 );

			strImageName.Replace( ".bmp", ""); strImageName.Replace( ".gif", ""); strImageName.Replace( ".png", ""); strImageName.Replace( ".tif", ""); strImageName.Replace( ".jpg", "");

			bitmap.LockBits( &rect, Gdiplus::ImageLockModeRead, bitmap.GetPixelFormat(), &bmp_data );			

			if ( bmp_data.PixelFormat == PixelFormat32bppRGB || bmp_data.PixelFormat == PixelFormat32bppARGB )
				nBitDepth = 32;
			else if ( bmp_data.PixelFormat == PixelFormat24bppRGB )
				nBitDepth = 24;

			if ( nBitDepth != 24 && nBitDepth != 32 ) continue;

			bConverting = true;
		
			lpThis->ippiRGBToYUV422((BYTE *)bmp_data.Scan0, bitmap.GetWidth(), bitmap.GetHeight(), nBitDepth, lpThis->m_pYUVFrameBuffer, &lpThis->m_nDstStreamBufferSize );  			

			lpThis->m_nDstStreamBufferSize = bitmap.GetWidth() * bitmap.GetHeight() * 2;

			lpThis->ImageDeinterlace( lpThis->m_pYUVFrameBuffer, bitmap.GetWidth(), bitmap.GetHeight(), lpThis->m_nDstStreamBufferSize );
		
			lpThis->YUV422toRGB(bitmap.GetWidth(), bitmap.GetHeight(), nBitDepth, lpThis->m_pYUVFrameBuffer, lpThis->m_pRGBFrameBuffer );			

			bitmap.UnlockBits(&bmp_data);			

			if (bConverting == true)
			{
				strMessage += "Convert image file : ";
				strMessage += strSrcImageFile;
				strMessage += "\r\n";

				strDstImageFile = strSrcImageFile;

				if ( !lpThis->m_strOutputDirectory.IsEmpty() )
					strDstImageFile = lpThis->m_strOutputDirectory + "\\" + strImageName;

				strDstImageFile.Replace( ".BMP", "_DEINTERLACE.BMP" );				

				strMessage += "Writing image file : ";
				strMessage += strDstImageFile;
				strMessage += "\r\n";

				lpThis->WriteToFile( strDstImageFile, bitmap.GetWidth(), bitmap.GetHeight(), nBitDepth );

				lpThis->m_listDestImage.AddString( strDstImageFile );

				nConvertFile++;

				CString strOutputFilesNum;

				strOutputFilesNum.Format("Output Files:  ( %d )", nConvertFile);

				lpThis->GetDlgItem(IDC_SC_OUTPUT_FILES)->SetWindowText( strOutputFilesNum );

				lpThis->m_editMessage.SetWindowText( strMessage );

				int nLineCount = lpThis->m_editMessage.GetLineCount();

				lpThis->m_editMessage.LineScroll( nLineCount );
				lpThis->m_editMessage.Invalidate();
			}
		}
	}	

	if (nConvertFile > 0)
	{
		strMessage += "Output file : ";
		strMessage += strDstImageFile;
		strMessage += "\r\n";
	}
	else
	{
		strMessage += "No output file be created !\r\n ";
	}

	lpThis->m_editMessage.SetWindowText(strMessage);

	int nLineCount = lpThis->m_editMessage.GetLineCount();

	lpThis->m_editMessage.LineScroll(nLineCount);

	lpThis->m_editMessage.Invalidate();

	lpThis->OnBtnStop();

	return 0;
}


void CImageDeinterlacerDlg::OnSelchangeListDestinationImage() 
{
	// TODO: Add your control notification handler code here
	
	int nIndex = m_listDestImage.GetCurSel();

	if (nIndex == LB_ERR)
		return;	

	CString	strImageFile;

	m_listDestImage.GetText( nIndex, strImageFile);

	// Load an Image from File
	//
    m_scDestImgPreview.Load( strImageFile );		

	m_scDestImgPreview.Invalidate();

	Invalidate();
}
